/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xstrreq.h
 * -----------------------------------------------------------------*/
 
#ifndef XSTREQ_H_INCLUDED
#define XSTREQ_H_INCLUDED

#include <string.h>


#ifndef UNIX
#  ifdef strcasecmp
#    undef strcasecmp
#  endif

#  ifdef __BORLANDC__
#    define strcasecmp stricmp
#  elif DOSW32
#    define strcasecmp stricmp
#  else
#    define strcasecmp _stricmp
#  endif
#endif


 /***********************************************************************
 * This function compares two strings
 * if s1 and s2 are equsl
 * TRUE is returned.
 * also returns TRUE if both strings are empty or non-existent
 ***********************************************************************/
static int str_eq ( const char * s1, const char * s2 )
{
  int retval = 0;
   
  if (s2 && *s2)
  {
    retval = ( (s1 != 0) && ( strcasecmp(s1, s2) == 0 ) );
  }
  else
  {
    retval = ( s1 == 0 || s1[0] == 0 );
  }

  return retval;
}


#endif
